
#include <Ultrasonic_Sensor.h>                  //Βιβλιοθήκη Αισθητήτα Υπερήχων
#include <Liquid_Crystal.h>                     //Βιβλιοθήκη oθόνης LCD

const int trigPin = 3;                          //Δήλωση της 1ης θύρας του αισθητήρα υπερήχων
const int echoPin = 4;                          //Δήλωση της 2ης θύρας του αισθητήρα υπερήχων

float t2;                                        // Δήλωση της μεταβλητής t2 (σε s) για τη μετάδοση του υπέρηχου από τον αισθητήρα έως το εμπόδιο και πίσω στον αισθητήρα

Ultrasonic_Sensor ultrasonic(trigPin, echoPin); // Έναρξη του αισθητήρα υπερήχων
LiquidCrystal myLCD(0x27, 16, 2);               // Έναρξη της LCD. H σύνδεση γίνεται στην θύρα I2C του Arduino

void setup() 
{
  myLCD.begin();                                // Εκκίνηση της οθόνης LCD
}

void loop() 
{
  ultrasonic.sendTriggerPulse();                // Αποστολή παλμού υπερήχου στο εμπόδιο
  
  long duration = ultrasonic.readEcho();        // Χρονικό διάστημα σε μs από την αποστολή του υπερήχου στο εμπόδιο έως την επιστροφή του υπερήχου στον αισθητήρα

  t2 = duration / 1000000.0;                    // Χρονικό διάστημα σε s για τη μετάδοση του υπερήχου από τον αισθητήρα έως το εμπόδιο και πίσω στον αισθητήτα

  myLCD.Text("Dt=", 0, 0);                       // Εμφάνιση του κειμένου "t=" στη θέση 0,0
  myLCD.Text(String(t2, 6).c_str(), 3, 0);       // Εμφάνιση του χρόνου με 6 δεκαδικά στη θέση 4,0
  myLCD.Text("s", 11, 0);                       // Εμφάνιση της μονάδας χρόνου "s" στη θέση 12,0

  delay(1000);                                  // Καθυστέρηση για να διαβάσουμε την τιμή
}